<?php
require_once 'config-db.php';

$query = $_POST['query'] ?? '';

if (strlen($query) < 2) {
    echo '<p class="text-center text-white py-3">Please enter at least 2 characters to search.</p>';
    exit;
}

// Search games
$pdo = getDB();
$stmt = $pdo->prepare("
    SELECT g.*, p.provider_name, p.provider_image, p.provider_code
    FROM games g
    JOIN providers p ON g.provider_code = p.provider_code
    WHERE g.is_active = 1
    AND g.game_name LIKE ?
    ORDER BY g.display_order ASC, g.id DESC
    LIMIT 50
");
$stmt->execute(['%' . $query . '%']);
$games = $stmt->fetchAll();

if (empty($games)) {
    echo '<p class="text-center text-white py-3">No games found for "' . htmlspecialchars($query) . '"</p>';
    exit;
}

$daftarLink = getSetting('daftar_link', 'https://google.com');

foreach ($games as $game):
?>
<div class="card card-game d-flex">
    <div class="game-link">
        <a class="btn btn-game text-uppercase" onclick="login()">MAIN</a>
    </div>
    <div class="game-item">
        <img class="game-item-img" loading="lazy" src="<?= htmlspecialchars($game['game_image_path']) ?>" alt="<?= htmlspecialchars($game['game_name']) ?>" onerror="this.src='img/placeholder.png'">
    </div>
    <div class="percent">
        <p class="percent-txt" style="z-index: 15"></p>
        <div class="percent-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="" style="width: 0"></div>
    </div>
    <span class="card-title"><?= htmlspecialchars($game['game_name']) ?></span>
    <div class="jam">
        <div class="jamgacor jamBg">
            <h5 class="jamgacorRange"></h5>
        </div>
        <div class="pola jamBg">
            <h5>POLA MAIN</h5>
            <p class="pola1"></p>
            <p class="pola2"></p>
            <p class="pola3"></p>
        </div>
    </div>
</div>
<?php endforeach; ?>
