// RTP & Pola Generator (Based on slot-joker.js logic)
var x = [963, 628, 1527, 2546, 1668, 2772, 2633, 2884, 882, 625, 841, 823, 2307, 2041, 2228, 2534, 1461, 1262, 2551, 363, 1907, 1674, 1785, 1849, 2257, 2620, 1144, 987, 1538, 1457, 567, 484, 2743, 1526, 1958, 2441, 363, 2685, 2250, 2108, 437, 607, 39, 914, 94, 2417, 1707, 279, 524, 657, 2316, 1640, 2926, 1739, 2197, 1178, 32, 119, 349, 769, 2953, 1981, 2969, 1052, 1259, 1876, 1155, 1087, 835, 1103, 1090, 2152, 1834, 2458, 756, 919, 1099, 635, 634, 2983, 1102, 1028, 1291, 274, 156, 1024, 2627, 500, 684, 476, 125, 1638, 1477, 2000, 2575, 2174, 2677, 366, 621, 2845, 730, 810, 1992, 2690, 175, 2986, 1369, 61, 2001, 313, 2121, 1198, 499, 2958, 1522, 1311, 2574, 402, 1723, 2367, 837, 1242, 312, 1193, 504, 1834, 153, 972, 1670, 171, 180, 524, 281, 997, 573, 1529, 2373, 1185, 2485, 318, 906, 1936, 1128, 2309, 2986, 216, 2219, 89, 740, 385, 374, 1004, 618, 1922, 2983, 18, 8, 1442, 1015, 93, 2414, 2027, 1425, 1914, 1840, 497, 2064, 2237, 1772, 2140, 2336, 1345, 2196, 2170, 856, 530, 1340, 1202, 2518, 2086, 2798, 1356, 315, 2161, 892, 2116, 1601, 2608, 1622, 888, 2090, 321, 1053, 2624, 571, 721, 183, 782, 1937, 518, 524, 430];

var random = ["❌ ❌ ❌", "❌ ❌ ✅", "❌ ✅ ❌", "✅ ❌ ❌", "✅ ✅ ❌", "❌ ✅ ✅"];
var random2 = [50, 10, 70, 20, 80];
var random3 = ["Auto", "Manual 9", "Auto", "Manual 7", "Manual Turbo 10", "Manual Turbo 15", "Manual Turbo", "Auto", "Auto", "Auto"];

var game = window.location.pathname;
var xxx = 0;
for (let i = 0; i < game.length; i++) {
    xxx += game.charCodeAt(i);
}

window.generatePolaPatterns = function() {
    var text = document.getElementsByClassName("percent-txt");
    var barr = document.getElementsByClassName("percent-bar");
    var jam = document.getElementsByClassName("jamgacorRange");
    var pola1 = [
        document.getElementsByClassName("pola1"),
        document.getElementsByClassName("pola2"),
        document.getElementsByClassName("pola3")
    ];
    var pola = document.getElementsByClassName("pola");
    var jambg = document.getElementsByClassName("jamgacor");

    for (let i = 0; i < text.length; i++) {
        const d = new Date();
        var date = d.getUTCDate();
        var day = d.getUTCDay() + 1;
        var year = d.getUTCFullYear();
        var month = d.getUTCMonth() + 1;
        var hour = d.getUTCHours();
        var min = d.getMinutes();

        if (min < 30) {
            min = 1;
        } else {
            min = 2;
        }

        var xx = day + year * month * date;
        xx = Math.pow(xx, hour * min);

        if (x[i]) {
            x[i] += xxx;
        } else {
            x[i] = xxx + Math.floor(Math.random() * 3000);
        }

        xx = xx * x[i];

        // RTP Calculation
        if (i >= 0 && i <= 15) {
            xx = xx % 27;
            xx += 65;
        } else {
            xx = xx % 83;
            xx += 8;
        }

        if (xx >= 30) {
            // Jam Gacor calculation
            var hour2 = (hour + 7) % 24;
            var target = (xx % 3) + 1;
            var randomTarget = (hour2 + target) % 24;

            if (randomTarget < 10) randomTarget = "0" + randomTarget;

            var min1 = xx % 60;
            var min2 = (xx * date) % 60;

            if (min1 < 10) min1 = "0" + min1;
            if (min2 < 10) min2 = "0" + min2;
            if (hour2 < 10) hour2 = "0" + hour2;

            jam[i].innerText = hour2 + ":" + min1 + " - " + randomTarget + ":" + min2;

            // Pola Pattern calculation
            var n = i % 6;
            var p = [
                (x[n] + xx) % 6,
                (x[(2 * n) % x.length] + xx) % 6,
                (x[(3 * n) % x.length] + xx) % 6
            ];

            var n2 = i % 5;
            var p2 = [
                (x[(4 * n2) % x.length] + xx) % 4,
                (x[(5 * n2) % x.length] + xx) % 5,
                (x[(6 * n2) % x.length] + xx) % 5
            ];

            // Ensure unique patterns
            for (let j = 0; j < 3; j++) {
                for (let k = 0; k < 3; k++) {
                    if (p[j] == p[k] && j != k) {
                        p[k] = (p[k] + 1) % 6;
                    }
                }
            }

            var p3 = [
                Math.pow(p[0], p2[0]) % 10,
                Math.pow(p[1], p2[1]) % 10,
                Math.pow(p[2], p2[2]) % 10
            ];

            // Generate pola text
            for (let j = 0; j < 3; j++) {
                if (random3[p3[j]] == "Auto" || random3[p3[j]].includes("Auto")) {
                    pola1[j][i].innerText = random2[p2[j]] + " " + random[p[j]] + " " + random3[p3[j]];
                } else {
                    pola1[j][i].innerText = random3[p3[j]] + " " + random[p[j]];
                }
            }

            // Jam gacor background color
            if (xx > 70) {
                jambg[i].style.backgroundColor = "#28a745";
            } else {
                jambg[i].style.backgroundColor = "#ffd800";
                jambg[i].style.color = "#000";
            }
        } else {
            // RTP < 30% - JANGAN MAIN
            jam[i].innerText = "-";
            jambg[i].style.backgroundColor = "#dc3545";
            pola[i].style.backgroundColor = "#dc3545";
            pola1[0][i].innerHTML = "<br>";
            pola1[1][i].innerHTML = "JANGAN MAIN !!";
            pola1[2][i].innerHTML = "<br>";
        }
    }
};
