<?php
require_once 'config-db.php';

// Get settings - CORRECT DATABASE KEYS!
$siteName = getSetting('site_name', 'BRAND');
$siteTitle = getSetting('meta_title', 'RTP Live Slot Gacor Online Terpercaya di Indonesia');
$siteDescription = getSetting('meta_description', 'Situs judi online penyedia rtp live slot gacor online terpercaya');
$siteKeywords = getSetting('meta_keywords', 'rtp live, rtp slot, rtp live slot');
$canonicalUrl = getSetting('canonical_url', 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
$favicon = getSetting('site_favicon', 'img/favicon.ico');
$logo = getSetting('site_logo', 'img/logo.png');
$marqueeText = getSetting('marquee_text', 'SELAMAT DATANG DI ' . $siteName . ' – SITUS NOMOR 1 DI INDONESIA!');
$daftarLink = getSetting('daftar_link', 'https://google.com');
$liveChatLink = getSetting('daftar_link', 'https://google.com'); // Use same as daftar since livechat not in DB
$banner1 = getSetting('banner_1', 'img/slide1.jpg');
$banner2 = getSetting('banner_2', '');
$banner3 = getSetting('banner_3', '');
$themeColor = getSetting('theme_color', 'biru');

// Get providers
$providers = getProviders();

// Get all games untuk display awal (first provider)
$firstProvider = !empty($providers) ? $providers[0] : null;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <title><?= htmlspecialchars($siteTitle) ?></title>
    <meta charset="UTF-8">
    <link itemprop="mainEntityOfPage" rel="canonical" href="<?= htmlspecialchars($canonicalUrl) ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,minimum-scale=1">
    <meta name="description" content="<?= htmlspecialchars($siteDescription) ?>">
    <meta name="keywords" content="<?= htmlspecialchars($siteKeywords) ?>">
    <meta name="author" content="<?= htmlspecialchars($siteName) ?>">
    <meta name="distribution" content="global">
    <meta name="language" content="id-ID">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#0a192f">
    <link rel="icon" type="image/webp" href="<?= htmlspecialchars($favicon) ?>">
    <link rel="shortcut icon" type="image/webp" href="<?= htmlspecialchars($favicon) ?>">
    <link rel="apple-touch-icon" type="image/webp" href="<?= htmlspecialchars($favicon) ?>">

    <script src="js/jquery-3.7.0.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="css/base.css?v=<?= time() ?>">
    <link rel="stylesheet" href="css/theme-<?= $themeColor ?>.css?v=<?= time() ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"/>

    <!-- Responsive Pola Card Styling -->
    <style>
        /* Responsive pola text sizing */
        .pola1, .pola2, .pola3 {
            font-size: 0.75rem;
            line-height: 1.4;
            margin: 0.15rem 0;
            padding: 0.2rem 0.3rem;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }

        /* Desktop sizing */
        @media (min-width: 768px) {
            .pola1, .pola2, .pola3 {
                font-size: 0.85rem;
                line-height: 1.5;
                margin: 0.2rem 0;
                padding: 0.25rem 0.4rem;
            }
        }

        /* Large desktop */
        @media (min-width: 1200px) {
            .pola1, .pola2, .pola3 {
                font-size: 0.9rem;
                line-height: 1.6;
                margin: 0.25rem 0;
                padding: 0.3rem 0.5rem;
            }
        }

        /* Ensure jam gacor range is also consistent */
        .jamgacorRange {
            font-size: 0.9rem;
            margin: 0.3rem 0;
        }

        @media (min-width: 768px) {
            .jamgacorRange {
                font-size: 1rem;
            }
        }

        /* Pola section title */
        .pola h5 {
            font-size: 0.85rem;
            margin-bottom: 0.3rem;
        }

        @media (min-width: 768px) {
            .pola h5 {
                font-size: 0.95rem;
            }
        }
    </style>
</head>
<body class="color-1">
    <!-- Header -->
    <header class="sticky-top color-2">
        <div class="container px-3 py-2">
            <div class="row no-gutters justify-content-center justify-content-lg-between align-items-center">
                <div class="col col-lg-auto">
                    <div class="logo-wrapper mb-lg-0">
                        <a href="games.php">
                            <img class="web-logo" src="<?= htmlspecialchars($logo) ?>" alt="<?= htmlspecialchars($siteName) ?>">
                        </a>
                    </div>
                </div>
                <div class="col-auto d-flex">
                    <div class="btn-group w-100">
                        <a target="_blank" href="<?= htmlspecialchars($daftarLink) ?>" class="btn btn-regis border-0 text-uppercase d-flex align-items-center py-2">
                            <span>DAFTAR</span>
                        </a>
                    </div>
                    <div class="btn-group w-100" style="margin-left:10px">
                        <a target="_blank" href="<?= htmlspecialchars($liveChatLink) ?>" class="btn btn-regis border-0 text-uppercase d-flex align-items-center py-2">
                            <span>LIVE CHAT</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Banner -->
    <section>
        <div class="container px-0 px-lg-3 pt-2 py-lg-2">
            <div id="carousel-slider" class="carousel slide" data-ride="carousel" data-interval="3000">
                <div class="carousel-inner">
                    <?php
                    $banners = [];
                    if (!empty($banner1)) $banners[] = $banner1;
                    if (!empty($banner2)) $banners[] = $banner2;
                    if (!empty($banner3)) $banners[] = $banner3;

                    if (empty($banners)) {
                        $banners[] = 'img/slide1.jpg'; // Fallback
                    }

                    foreach ($banners as $index => $bannerUrl):
                    ?>
                    <div class="carousel-item <?= $index === 0 ? 'active' : '' ?> bg-color-1">
                        <img src="<?= htmlspecialchars($bannerUrl) ?>" loading="lazy" class="d-block w-100" alt="RTP Slot Banner <?= $index + 1 ?>">
                    </div>
                    <?php endforeach; ?>
                </div>

                <?php if (count($banners) > 1): ?>
                <!-- Carousel Controls -->
                <a class="carousel-control-prev" href="#carousel-slider" role="button" data-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="sr-only">Previous</span>
                </a>
                <a class="carousel-control-next" href="#carousel-slider" role="button" data-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="sr-only">Next</span>
                </a>

                <!-- Indicators -->
                <ol class="carousel-indicators">
                    <?php foreach ($banners as $index => $banner): ?>
                    <li data-target="#carousel-slider" data-slide-to="<?= $index ?>" class="<?= $index === 0 ? 'active' : '' ?>"></li>
                    <?php endforeach; ?>
                </ol>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Marquee -->
    <section>
        <div class="container bg-transparent px-2 px-lg-3">
            <div class="row no-gutters justify-content-between align-items-center">
                <div class="col pl-lg-0 pr-lg-2">
                    <div class="d-none d-lg-flex color-3 rounded-1 px-2 py-1 align-items-center">
                        <i class="fas fa-bullhorn" style="margin-right: 10px;"></i>
                        <marquee class="text-black" style="width: 100%;">
                            <span><b><?= htmlspecialchars($marqueeText) ?></b></span>
                        </marquee>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section>
        <div class="container px-2 px-lg-3 py-2">
            <div class="row no-gutters">
                <!-- Sidebar Providers (Desktop) -->
                <div class="col-12 col-lg-2">
                    <!-- Mobile Provider Carousel -->
                    <div class="d-block d-lg-none px-0 pb-2">
                        <div class="carousel-game" style="padding:5px 0">
                            <div class="row align-items-center py-1">
                                <div class="col">
                                    <div class="prev">
                                        <img src="assets/img/icon-left.png" width=50px height=50px>
                                    </div>
                                </div>
                                <div id="owl-game" class="owl-carousel owl-theme g-1">
                                    <?php foreach ($providers as $provider): ?>
                                    <div class="item active">
                                        <a href="#" data-provider-id="<?= $provider['id'] ?>" class="provider-link">
                                            <div class="card-provider">
                                                <img class="provider-thumbnail" src="<?= htmlspecialchars($provider['provider_image']) ?>" alt="<?= htmlspecialchars($provider['provider_name']) ?>">
                                            </div>
                                            <span><?= htmlspecialchars($provider['provider_name']) ?></span>
                                        </a>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                                <div class="col">
                                    <div class="next">
                                        <img src="assets/img/icon-right.png" width=50px height=50px>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Desktop Provider Sidebar -->
                    <div class="d-none d-lg-block color-3 mr-n1">
                        <div class="list-group px-0 py-0">
                            <?php $first = true; foreach ($providers as $provider): ?>
                            <div class="list-group-item list-group-item-action <?= $first ? 'active' : '' ?> px-0 py-0">
                                <a href="#" data-provider-id="<?= $provider['id'] ?>" class="provider-link d-flex justify-content-start align-items-center px-2 py-2">
                                    <img class="provider-thumbnail" src="<?= htmlspecialchars($provider['provider_image']) ?>" alt="<?= htmlspecialchars($provider['provider_name']) ?>">
                                    <span><?= htmlspecialchars($provider['provider_name']) ?></span>
                                </a>
                            </div>
                            <?php $first = false; endforeach; ?>
                        </div>
                    </div>
                </div>

                <!-- Game Cards Area -->
                <div class="col-12 col-lg-10">
                    <div class="color-3">
                        <div class="rtp-header">
                            <div class="px-2 py-2 d-flex justify-content-between align-items-center">
                                <h4 class="animate-charcter m-0">
                                    <i class="fas fa-chart-line"></i> RTP LIVE SLOT <span id="current-provider-name"></span>
                                </h4>
                                <input type="text" id="search" placeholder="Cari game..." class="form-control form-control-sm" style="max-width: 200px;">
                            </div>
                        </div>
                        <div class="rtp-body px-2 py-1">
                            <div id="game-container" class="card-deck row row-col-5 no-gutters">
                                <!-- Games akan dimuat via AJAX -->
                            </div>
                            <div id="loading" class="text-center py-3" style="display: none;">
                                <i class="fas fa-spinner fa-spin fa-2x"></i>
                                <p>Loading games...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-text py-3 text-center">
        <p class="m-0">&copy; <?= date('Y') ?> <?= htmlspecialchars($siteName) ?>. All Rights Reserved.</p>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <script>
    // Initialize Owl Carousel for mobile providers
    $(document).ready(function(){
        $("#owl-game").owlCarousel({
            loop: false,
            margin: 5,
            nav: false,
            dots: false,
            responsive:{
                0:{
                    items:4
                },
                600:{
                    items:6
                }
            }
        });

        // Navigation buttons
        $('.prev').click(function() {
            $("#owl-game").trigger('prev.owl.carousel');
        });
        $('.next').click(function() {
            $("#owl-game").trigger('next.owl.carousel');
        });

        // Load first provider games
        <?php if ($firstProvider): ?>
        loadProviderGames(<?= $firstProvider['id'] ?>);
        $('#current-provider-name').text('- <?= htmlspecialchars($firstProvider['provider_name']) ?>');
        <?php endif; ?>

        // Provider click handler
        $(document).on('click', '.provider-link', function(e) {
            e.preventDefault();
            var providerId = $(this).data('provider-id');
            var providerName = $(this).find('span').text();

            // Update active state
            $('.list-group-item').removeClass('active');
            $(this).closest('.list-group-item').addClass('active');

            // Update provider name in header
            $('#current-provider-name').text('- ' + providerName);

            // Load games
            loadProviderGames(providerId);
        });

        // Search functionality
        let searchTimeout;
        $('#search').on('keyup', function() {
            clearTimeout(searchTimeout);
            var query = $(this).val();
            searchTimeout = setTimeout(function() {
                searchGames(query);
            }, 500);
        });

        // Infinite scroll for load more
        $(window).scroll(function() {
            if ($(window).scrollTop() + $(window).height() > $(document).height() - 500) {
                loadMoreGames();
            }
        });
    });

    let currentPage = 1;
    let currentProviderId = null;
    let isLoading = false;
    let hasMoreGames = true;

    function loadProviderGames(providerId) {
        currentProviderId = providerId;
        currentPage = 1;
        hasMoreGames = true;
        isLoading = false;

        $('#loading').show();
        $('#game-container').html('');

        $.ajax({
            url: 'load-games.php',
            method: 'POST',
            data: {
                provider_id: providerId,
                page: 1,
                limit: 20
            },
            success: function(response) {
                $('#loading').hide();
                if (response.trim() === '' || response.includes('No games found')) {
                    $('#game-container').html('<p class="text-center text-white py-3">No games available for this provider.</p>');
                    hasMoreGames = false;
                } else {
                    $('#game-container').html(response);
                    initializeGames();
                }
            },
            error: function() {
                $('#loading').hide();
                $('#game-container').html('<p class="text-center text-white py-3">Error loading games. Please try again.</p>');
                hasMoreGames = false;
            }
        });
    }

    function loadMoreGames() {
        if (isLoading || !hasMoreGames || !currentProviderId) return;

        isLoading = true;
        currentPage++;

        $('#loading').show();

        $.ajax({
            url: 'load-games.php',
            method: 'POST',
            data: {
                provider_id: currentProviderId,
                page: currentPage,
                limit: 20
            },
            success: function(response) {
                $('#loading').hide();
                isLoading = false;

                if (response.trim() === '' || response.includes('No games found')) {
                    hasMoreGames = false;
                } else {
                    $('#game-container').append(response);
                    initializeGames();
                }
            },
            error: function() {
                $('#loading').hide();
                isLoading = false;
                currentPage--; // Rollback page
            }
        });
    }

    function searchGames(query) {
        if (query.length < 2) {
            // Reload current provider if search is cleared
            var activeProvider = $('.list-group-item.active .provider-link').data('provider-id');
            if (activeProvider) {
                var providerName = $('.list-group-item.active .provider-link span').text();
                $('#current-provider-name').text('- ' + providerName);
                loadProviderGames(activeProvider);
            }
            return;
        }

        // Update header to show search mode
        $('#current-provider-name').text('- Search: "' + query + '"');
        $('#loading').show();
        $('#game-container').html('');

        $.ajax({
            url: 'search-games.php',
            method: 'POST',
            data: { query: query },
            success: function(response) {
                $('#loading').hide();
                if (response.trim() === '' || response.includes('No games found')) {
                    $('#game-container').html('<p class="text-center text-white py-3">Tidak ada game ditemukan untuk "' + query + '"</p>');
                } else {
                    $('#game-container').html(response);
                    initializeGames();
                }
            },
            error: function() {
                $('#loading').hide();
                $('#game-container').html('<p class="text-center text-white py-3">Error searching games.</p>');
            }
        });
    }

    function login() {
        window.open('<?= htmlspecialchars($daftarLink) ?>', '_blank');
    }

    // Simple hash function
    function simpleHash(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = ((hash << 5) - hash) + str.charCodeAt(i);
            hash = hash & hash;
        }
        return Math.abs(hash);
    }

    // Generate RTP, Jam Gacor, and Pola for all games
    function initializeGames() {
        const now = new Date();
        const hour = now.getHours();
        const date = now.getDate();
        const timeSlot = Math.floor(now.getTime() / (30 * 60 * 1000)); // 30-minute intervals

        $('.card-game').each(function(index) {
            const card = $(this);
            const gameName = card.find('.card-title').text();

            // Generate RTP (30-98%)
            const seed = simpleHash(gameName + timeSlot);
            let rtpValue = 30 + (seed % 69);

            // RTP color and animation
            const percentBar = card.find('.percent-bar');
            const percentTxt = card.find('.percent-txt');

            percentBar.removeClass('green yellow red');
            if (rtpValue >= 80) {
                percentBar.addClass('green');
            } else if (rtpValue >= 50) {
                percentBar.addClass('yellow');
            } else {
                percentBar.addClass('red');
            }

            setTimeout(function() {
                percentBar.css('width', rtpValue + '%');
                percentTxt.text(rtpValue + '%');
            }, 100);

            // Generate Jam Gacor
            const hour1 = (hour + (seed % 4)) % 24;
            const hour2 = (hour1 + 2 + (seed % 3)) % 24;
            const min1 = String((rtpValue + date) % 60).padStart(2, '0');
            const min2 = String((rtpValue * 2 + date) % 60).padStart(2, '0');
            const jamGacor = String(hour1).padStart(2, '0') + ':' + min1 + ' - ' + String(hour2).padStart(2, '0') + ':' + min2;

            card.find('.jamgacorRange').text(jamGacor);

            // Generate 3 Pola Patterns
            const spinTypes = ['Auto', 'Manual 3', 'Manual 5', 'Manual 7', 'Manual 9'];
            const spinValues = [10, 20, 30, 50, 70, 100];
            const turboStatus = ['Turbo On ✅', 'Turbo Off ❌'];

            // Pola 1
            const spinType1 = spinTypes[(seed + index) % spinTypes.length];
            const spinValue1 = spinValues[(seed + index * 2) % spinValues.length];
            const turbo1 = turboStatus[(seed + index * 3) % turboStatus.length];
            let pola1Text = spinType1 === 'Auto' ? `${spinType1} ${spinValue1} • ${turbo1}` : `${spinType1} • ${turbo1}`;

            // Pola 2
            const spinType2 = spinTypes[(seed + index + 1) % spinTypes.length];
            const spinValue2 = spinValues[(seed + index * 3 + 1) % spinValues.length];
            const turbo2 = turboStatus[(seed + index * 4 + 1) % turboStatus.length];
            let pola2Text = spinType2 === 'Auto' ? `${spinType2} ${spinValue2} • ${turbo2}` : `${spinType2} • ${turbo2}`;

            // Pola 3
            const spinType3 = spinTypes[(seed + index + 2) % spinTypes.length];
            const spinValue3 = spinValues[(seed + index * 4 + 2) % spinValues.length];
            const turbo3 = turboStatus[(seed + index * 5 + 2) % turboStatus.length];
            let pola3Text = spinType3 === 'Auto' ? `${spinType3} ${spinValue3} • ${turbo3}` : `${spinType3} • ${turbo3}`;

            card.find('.pola1').text(pola1Text);
            card.find('.pola2').text(pola2Text);
            card.find('.pola3').text(pola3Text);

            // Background color based on RTP (SAME THRESHOLD AS RTP BAR!)
            const jamBg = card.find('.jamgacor');
            const polaBg = card.find('.pola');

            if (rtpValue >= 80) {
                // GREEN - High RTP
                jamBg.css('background-color', '#28a745');
                polaBg.css('background-color', '#28a745');
                jamBg.css('color', '#fff');
                polaBg.css('color', '#fff');
            } else if (rtpValue >= 50) {
                // YELLOW - Medium RTP
                jamBg.css('background-color', '#ffd800');
                polaBg.css('background-color', '#ffd800');
                jamBg.css('color', '#000');
                polaBg.css('color', '#000');
            } else {
                // RED - Low RTP (< 50%) - JANGAN MAIN!!
                jamBg.css('background-color', '#dc3545');
                polaBg.css('background-color', '#dc3545');
                jamBg.css('color', '#fff');
                polaBg.css('color', '#fff');
                card.find('.pola1').html('');
                card.find('.pola2').html('<strong>JANGAN MAIN !!</strong>');
                card.find('.pola3').html('');
            }
        });
    }
    </script>
</body>
</html>
