<?php
define('ADMIN_ACCESS', true);
require_once 'config/database.php';
require_once 'config/functions.php';

startSecureSession();
requireLogin();

$currentAdmin = getCurrentAdmin();
$pdo = getDBConnection();

$statsProviders = $pdo->query("SELECT COUNT(*) as total FROM providers WHERE is_active = 1")->fetch()['total'];
$statsGames = $pdo->query("SELECT COUNT(*) as total FROM games WHERE is_active = 1")->fetch()['total'];
$statsTotalGames = $pdo->query("SELECT COUNT(*) as total FROM games")->fetch()['total'];
$statsAdmins = $pdo->query("SELECT COUNT(*) as total FROM admin_users WHERE is_active = 1")->fetch()['total'];

$flashMessage = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Saira:wght@400;500;600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        h1, h2, h3, h4 { font-family: 'Saira', sans-serif; }
        .stat-card { transition: all 0.3s ease; }
        .stat-card:hover { transform: translateY(-5px); box-shadow: 0 20px 40px rgba(0,0,0,0.1); }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in',
                        'slide-in': 'slideIn 0.4s ease-out',
                    },
                    keyframes: {
                        fadeIn: { '0%': { opacity: '0' }, '100%': { opacity: '1' } },
                        slideIn: { '0%': { transform: 'translateY(20px)', opacity: '0' }, '100%': { transform: 'translateY(0)', opacity: '1' } }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 min-h-screen">

    <?php require_once 'includes/navbar.php'; ?>

    <main class="ml-64 p-8">
        <div class="mb-8 animate-fade-in">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Dashboard</h1>
            <p class="text-gray-600">Welcome back, <span class="font-semibold text-blue-600"><?= htmlspecialchars($currentAdmin['full_name'] ?? $currentAdmin['username']) ?></span></p>
        </div>

        <?php if ($flashMessage): ?>
            <div class="mb-6 animate-slide-in">
                <?php if ($flashMessage['type'] === 'success'): ?>
                    <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
                        <div class="flex items-center">
                            <i class="ri-checkbox-circle-line text-2xl text-green-500 mr-3"></i>
                            <p class="text-green-800"><?= htmlspecialchars($flashMessage['message']) ?></p>
                        </div>
                    </div>
                <?php elseif ($flashMessage['type'] === 'error'): ?>
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
                        <div class="flex items-center">
                            <i class="ri-error-warning-line text-2xl text-red-500 mr-3"></i>
                            <p class="text-red-800"><?= htmlspecialchars($flashMessage['message']) ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div class="stat-card bg-white rounded-xl shadow-sm border border-gray-200 p-6 animate-slide-in" style="animation-delay: 0.1s">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-blue-100 p-3 rounded-lg">
                        <i class="ri-store-2-line text-3xl text-blue-600"></i>
                    </div>
                    <span class="text-3xl font-bold text-gray-800"><?= $statsProviders ?></span>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-1">Providers</h3>
                <p class="text-gray-500 text-sm">Total provider aktif</p>
            </div>

            <div class="stat-card bg-white rounded-xl shadow-sm border border-gray-200 p-6 animate-slide-in" style="animation-delay: 0.2s">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-green-100 p-3 rounded-lg">
                        <i class="ri-gamepad-line text-3xl text-green-600"></i>
                    </div>
                    <span class="text-3xl font-bold text-gray-800"><?= $statsGames ?></span>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-1">Active Games</h3>
                <p class="text-gray-500 text-sm">Game yang aktif</p>
            </div>

            <div class="stat-card bg-white rounded-xl shadow-sm border border-gray-200 p-6 animate-slide-in" style="animation-delay: 0.3s">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-purple-100 p-3 rounded-lg">
                        <i class="ri-apps-line text-3xl text-purple-600"></i>
                    </div>
                    <span class="text-3xl font-bold text-gray-800"><?= $statsTotalGames ?></span>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-1">Total Games</h3>
                <p class="text-gray-500 text-sm">Semua game</p>
            </div>

            <div class="stat-card bg-white rounded-xl shadow-sm border border-gray-200 p-6 animate-slide-in" style="animation-delay: 0.4s">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-orange-100 p-3 rounded-lg">
                        <i class="ri-admin-line text-3xl text-orange-600"></i>
                    </div>
                    <span class="text-3xl font-bold text-gray-800"><?= $statsAdmins ?></span>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-1">Admin Users</h3>
                <p class="text-gray-500 text-sm">Total admin</p>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mb-8 animate-slide-in" style="animation-delay: 0.5s">
            <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                <i class="ri-flashlight-line mr-3 text-blue-600"></i>
                Quick Actions
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <a href="bulk-add-games.php" class="flex items-center space-x-4 p-4 bg-orange-50 border border-orange-200 rounded-lg hover:bg-orange-100 transition">
                    <div class="bg-orange-500 p-3 rounded-lg">
                        <i class="ri-file-list-3-line text-2xl text-white"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold text-gray-800">Bulk Add Games</h4>
                        <p class="text-sm text-gray-600">Add multiple games</p>
                    </div>
                </a>

                <a href="games.php?action=add" class="flex items-center space-x-4 p-4 bg-blue-50 border border-blue-200 rounded-lg hover:bg-blue-100 transition">
                    <div class="bg-blue-500 p-3 rounded-lg">
                        <i class="ri-add-line text-2xl text-white"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold text-gray-800">Tambah Game</h4>
                        <p class="text-sm text-gray-600">Add new game</p>
                    </div>
                </a>

                <a href="providers.php?action=add" class="flex items-center space-x-4 p-4 bg-green-50 border border-green-200 rounded-lg hover:bg-green-100 transition">
                    <div class="bg-green-500 p-3 rounded-lg">
                        <i class="ri-store-add-line text-2xl text-white"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold text-gray-800">Manage Providers</h4>
                        <p class="text-sm text-gray-600">Add provider</p>
                    </div>
                </a>

                <a href="settings.php" class="flex items-center space-x-4 p-4 bg-purple-50 border border-purple-200 rounded-lg hover:bg-purple-100 transition">
                    <div class="bg-purple-500 p-3 rounded-lg">
                        <i class="ri-settings-4-line text-2xl text-white"></i>
                    </div>
                    <div>
                        <h4 class="font-semibold text-gray-800">Settings</h4>
                        <p class="text-sm text-gray-600">Configure site</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 animate-slide-in" style="animation-delay: 0.6s">
            <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                <i class="ri-information-line mr-3 text-blue-600"></i>
                System Information
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="flex items-center space-x-3 p-4 bg-gray-50 rounded-lg">
                    <i class="ri-time-line text-2xl text-gray-600"></i>
                    <div>
                        <p class="text-sm text-gray-600">Last Login</p>
                        <p class="font-semibold text-gray-800">
                            <?= $currentAdmin['last_login'] ? date('d M Y, H:i', strtotime($currentAdmin['last_login'])) : 'First time login' ?>
                        </p>
                    </div>
                </div>
                <div class="flex items-center space-x-3 p-4 bg-gray-50 rounded-lg">
                    <i class="ri-calendar-line text-2xl text-gray-600"></i>
                    <div>
                        <p class="text-sm text-gray-600">Account Created</p>
                        <p class="font-semibold text-gray-800">
                            <?= date('d M Y', strtotime($currentAdmin['created_at'])) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </main>

</body>
</html>
